/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.XFrameRsfRequestBody;

public class CloningRequestBody
extends XFrameRsfRequestBody {
    private static final String TRACE_MASKT = "XRSFXF T";
    private static final String TRACE_MASKF = "XRSFXF F";
    private static final String TRACE_MASKD = "XRSFXF D";
    public static final String CLONE_DATA_SOURCE = "Clone Source";
    public static final String CLONE_DATA_VERSION = "Clone Version";
    public static final String CLONE_DATA_PASSWORD = "Clone Password";
    public static final String CLONE_DATA_FQFN = "Clone File";
    public static final char CLONE_DATA_RETRIEVE = '2';
    public static final char CLONE_DATA_CREATE = '0';
    public static final char CLONE_DATA_REPLACE = '1';
    public static final int REASON_FILE_NOT_FOUND = 201;
    public static final int REASON_BAD_PASSWORD = 202;

    public CloningRequestBody() {
        this.functionUserid = (char)67;
    }

    public CloningRequestBody(PersistentData data) {
        super(((Persistent)data).parentData);
    }

    public PersistentData getPersistentData() {
        Persistent result = new Persistent();
        result.parentData = super.getPersistentData();
        return result;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.functionId == ' ') {
            this.invalidMessage = "No Cloning function type specified.";
        } else if (this.getAttribute(CLONE_DATA_SOURCE) == null) {
            this.invalidMessage = "No clone data source specified.";
        } else if (this.getAttribute(CLONE_DATA_VERSION) == null) {
            this.invalidMessage = "No clone data version specified.";
        } else if (this.getAttribute(CLONE_DATA_PASSWORD) == null) {
            this.invalidMessage = "No clone data password specified.";
        } else if (this.getAttribute(CLONE_DATA_FQFN) == null) {
            this.invalidMessage = "No clone data fully qualified file name specified.";
        } else {
            return true;
        }
        Trace.trace(TRACE_MASKF, "CloningRequestBody.isValid: " + this.invalidMessage);
        return false;
    }

    public void setFunctionType(char type) throws IllegalArgumentException {
        if (type != '2' && type != '1' && type != '0') {
            Trace.trace(TRACE_MASKF, "CloningRequestBody.setFunctionType: invalid function type: '" + type + "'");
            throw new IllegalArgumentException("Invalid function type specified for CloningRequestBody");
        }
        this.functionId = type;
    }

    public char getFunctionType() {
        return this.functionId;
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toXmlTransferFormat());
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.buildUseridAndFunction());
        buffer.append(super.toString());
        return buffer.toString();
    }

    private static class Persistent
    implements PersistentData {
        PersistentData parentData;
        int version = 0;
        private static final long serialVersionUID = 1L;

        private Persistent() {
        }
    }
}

